/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.simulation;

import filenet.sim.apps.designer.images.VWSIMImageLoader;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.canvas.simulation.VWScenarioCanvasPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;

class VWScenarioMainToolBar
extends JToolBar
implements ActionListener {
    private AbstractButton m_validateButton = null;
    private AbstractButton m_startSimulationButton = null;
    private AbstractButton m_helpButton = null;
    private VWScenarioCanvasPanel m_scenarioCanvasPanel = null;

    public VWScenarioMainToolBar(VWScenarioCanvasPanel scenarioCanvasPanel) {
        this.m_scenarioCanvasPanel = scenarioCanvasPanel;
        this.createControls();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_validateButton)) {
            VWSIMPropertyData propertyData = this.m_scenarioCanvasPanel.getPropertyData();
            if (propertyData != null) {
                this.m_scenarioCanvasPanel.getDesignerCoreData().getScenarioMenuHelper().validateScenario(propertyData);
            }
        } else if (event.getSource().equals(this.m_startSimulationButton)) {
            VWSIMPropertyData propertyData = this.m_scenarioCanvasPanel.getPropertyData();
            if (propertyData != null) {
                this.m_scenarioCanvasPanel.getDesignerCoreData().getScenarioMenuHelper().launchScenario(propertyData);
            }
        } else if (event.getSource().equals(this.m_helpButton)) {
            this.m_scenarioCanvasPanel.performHelpAction();
        }
    }

    protected void releaseReferences() {
        if (this.m_validateButton != null) {
            this.m_validateButton.removeActionListener(this);
            this.m_validateButton = null;
        }
        if (this.m_startSimulationButton != null) {
            this.m_startSimulationButton.removeActionListener(this);
            this.m_startSimulationButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton = null;
        }
        this.removeAll();
    }

    private void createControls() {
        this.setFloatable(false);
        this.m_validateButton = this.addToolbarButton("validate.gif", VWResource.s_validateScenarioToolTip, false);
        this.m_startSimulationButton = this.addToolbarButton("launch.gif", VWResource.s_launchScenarioToolTip, false);
        VWSIMImageLoader.addToolbarSeparator(this);
        this.m_helpButton = this.addToolbarButton("help.gif", VWResource.s_help, false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
    }

    private AbstractButton addToolbarButton(String fileName, String toolTip, boolean bUseToggleButton) {
        AbstractButton button = VWSIMImageLoader.createToolBarButton(fileName, toolTip, bUseToggleButton);
        if (button != null) {
            this.add(button);
            button.setRolloverEnabled(true);
            button.addActionListener(this);
        }
        return button;
    }
}

